/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.trees;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.PosInfo;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.joml.Vector3f;

public class LacugroveFeature
extends DefaultFeature {
    private static final Function<BlockState, Boolean> REPLACE = state -> {
        if (EndBlocks.LACUGROVE.isTreeLog((BlockState)state)) {
            return true;
        }
        if (state.m_60734_() == EndBlocks.LACUGROVE_LEAVES) {
            return true;
        }
        return BlocksHelper.replaceableOrPlant((BlockState)state);
    };
    private static final Function<BlockState, Boolean> IGNORE = EndBlocks.LACUGROVE::isTreeLog;
    private static final Function<PosInfo, BlockState> POST = info -> {
        if (EndBlocks.LACUGROVE.isTreeLog(info.getStateUp()) && EndBlocks.LACUGROVE.isTreeLog(info.getStateDown())) {
            return EndBlocks.LACUGROVE.getLog().m_49966_();
        }
        return info.getState();
    };

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.m_225041_();
        BlockPos pos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        if (!world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13077_)) {
            return false;
        }
        float size = MHelper.randRange((int)15, (int)25, (RandomSource)random);
        List spline = SplineHelper.makeSpline((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)size, (float)0.0f, (int)6);
        SplineHelper.offsetParts((List)spline, (RandomSource)random, (float)1.0f, (float)0.0f, (float)1.0f);
        if (!SplineHelper.canGenerate((List)spline, (BlockPos)pos, (WorldGenLevel)world, REPLACE)) {
            return false;
        }
        OpenSimplexNoise noise = new OpenSimplexNoise(random.m_188505_());
        float radius = MHelper.randRange((float)6.0f, (float)8.0f, (RandomSource)random);
        Vector3f center = (Vector3f)spline.get(4);
        this.leavesBall(world, pos.m_7918_((int)center.x(), (int)center.y(), (int)center.z()), radius *= (size - 15.0f) / 20.0f + 1.0f, random, noise);
        radius = MHelper.randRange((float)1.2f, (float)1.8f, (RandomSource)random);
        SDF function = SplineHelper.buildSDF((List)spline, (float)radius, (float)0.7f, bpos -> EndBlocks.LACUGROVE.getBark().m_49966_());
        function.setReplaceFunction(REPLACE);
        function.addPostProcess(POST);
        function.fillRecursive((ServerLevelAccessor)world, pos);
        spline = spline.subList(4, 6);
        SplineHelper.fillSpline(spline, (WorldGenLevel)world, (BlockState)EndBlocks.LACUGROVE.getBark().m_49966_(), (BlockPos)pos, REPLACE);
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        int offset = random.m_188503_(2);
        block0: for (int i = 0; i < 100; ++i) {
            int top;
            double distance;
            double px = pos.m_123341_() + MHelper.randRange((int)-5, (int)5, (RandomSource)random);
            double pz = pos.m_123343_() + MHelper.randRange((int)-5, (int)5, (RandomSource)random);
            mut.m_142451_(MHelper.floor((double)(px + 0.5)));
            mut.m_142443_(MHelper.floor((double)(pz + 0.5)));
            if ((mut.m_123341_() + mut.m_123343_() + offset & 1) != 0 || !((distance = 3.5 - MHelper.length((double)(px - (double)pos.m_123341_()), (double)(pz - (double)pos.m_123343_())) * 0.5) > 0.0)) continue;
            int minY = MHelper.floor((double)((double)pos.m_123342_() - distance * 0.5));
            int maxY = MHelper.floor((double)((double)pos.m_123342_() + distance + random.m_188500_()));
            boolean generate = false;
            for (int y = minY; y < maxY; ++y) {
                mut.m_142448_(y);
                if (!world.m_8055_((BlockPos)mut).m_204336_(CommonBlockTags.END_STONES)) continue;
                generate = true;
                break;
            }
            if (!generate) continue;
            for (int y = top = maxY - 1; y >= minY; --y) {
                mut.m_142448_(y);
                BlockState state = world.m_8055_((BlockPos)mut);
                if (!BlocksHelper.replaceableOrPlant((BlockState)state).booleanValue() && !state.m_204336_(CommonBlockTags.END_STONES)) continue block0;
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)(y == top ? EndBlocks.LACUGROVE.getBark() : EndBlocks.LACUGROVE.getLog()));
            }
        }
        return true;
    }

    private void leavesBall(WorldGenLevel world, BlockPos pos, float radius, RandomSource random, OpenSimplexNoise noise) {
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock((BlockState)EndBlocks.LACUGROVE_LEAVES.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(6)));
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.2, (double)vec.y() * 0.2, (double)vec.z() * 0.2) * 3.0f)).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(random.m_188501_() * 3.0f - 1.5f)).setSource((SDF)sphere);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)new SDFTranslate().setTranslate(0.0f, -radius - 2.0f, 0.0f).setSource((SDF)sphere));
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        sphere.addPostProcess(info -> {
            if (random.m_188503_(5) == 0) {
                for (Direction dir : Direction.values()) {
                    BlockState state = info.getState(dir, 2);
                    if (!state.m_60795_()) continue;
                    return info.getState();
                }
                info.setState(EndBlocks.LACUGROVE.getBark().m_49966_());
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.m_142451_(x + info.getPos().m_123341_());
                    for (int z = -6; z < 7; ++z) {
                        int az = Math.abs(z);
                        mut.m_142443_(z + info.getPos().m_123343_());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + az;
                            if (d >= 7) continue;
                            mut.m_142448_(y + info.getPos().m_123342_());
                            BlockState state = info.getState((BlockPos)mut);
                            if (!(state.m_60734_() instanceof LeavesBlock) || d >= (distance = ((Integer)state.m_61143_((Property)LeavesBlock.f_54418_)).intValue())) continue;
                            info.setState((BlockPos)mut, (BlockState)state.m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore((ServerLevelAccessor)world, pos, IGNORE);
        if (radius > 5.0f) {
            int count = (int)(radius * 2.5f);
            for (int i = 0; i < count; ++i) {
                BlockPos p = pos.m_7918_((int)(random.m_188583_() * 1.0), (int)(random.m_188583_() * 1.0), (int)(random.m_188583_() * 1.0));
                boolean place = true;
                for (Direction d : Direction.values()) {
                    BlockState state = world.m_8055_(p.m_121945_(d));
                    if (EndBlocks.LACUGROVE.isTreeLog(state) || state.m_60713_(EndBlocks.LACUGROVE_LEAVES)) continue;
                    place = false;
                    break;
                }
                if (!place) continue;
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (Block)EndBlocks.LACUGROVE.getBark());
            }
        }
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (Block)EndBlocks.LACUGROVE.getBark());
    }
}

